      program node
c ------------------------------------------------------
c Example fortran program illustrating use of PVM calls
c ------------------------------------------------------
      integer  info, mynum, hostnum, bytes, msgtype
      double precision result, data(100)
      double precision work
      character*16 host

c     Enroll this program in PVM 
      call fenroll( "node", mynum )
      if( mynum .lt. 0) then
	 print *,'failure in fenroll on node'
	 stop
      endif

c ------- Begin user program -------- 

c     Receive data from host 
      msgtype  = 1 
      call frcv( msgtype, info ) 
      call fgetnint( n, 1, info )
      call fgetnint( nproc, 1, info )
      call fgetndfloat( data, n, info ) 
      call frcvinfo( bytes, msgtype, host, hostnum, info )
 
c     Do calculations with data
      result = work( n, data, mynum, nproc ) 
                    
c     Send result to host 
      call finitsend()
      call fputndfloat( result, 1, info )
      msgtype  = 2 
      call fsnd( "fhost", hostnum, msgtype, info ) 

c --------- End user program -------- 

c     Program finished. Leave PVM before exiting 
      call fleave() 
      stop
      end

      double precision function work( n, data, me, nproc )
c    --------------------------------------
c     Just a simple routine for illustration
c    --------------------------------------
      double precision data(*), sum, psum
      integer i, n, me, inum

      sum = 0.0
      do 10 i=1,n
	sum = sum + me * data(i)
 10   continue
c     ----------------------------------------
c     Pass partial result to neighboring node
c     to illustrate node-to-node communication
c     ----------------------------------------
      call finitsend()
      call fputndfloat(sum, 1, info)
      inum = me+1
      if( inum .eq. nproc ) inum = 0
      call fsnd( "node", inum, 77, info )
      call frcv( 77, info )
      call fgetndfloat(psum, 1, info)

      work = sum + psum
      return
      end
